﻿using Microsoft.Xrm.Sdk;
using System.Threading.Tasks;
using VA.PPMS.Context.Interface;
using VA.PPMS.IWS.ProviderAgreementService.Interface;

namespace VA.PPMS.IWS.ProviderAgreementService
{
    public class ProviderAgreementService : IProviderAgreementService
    {
        private readonly IPpmsContextHelper _ppmsContextHelper;
        
        public ProviderAgreementService(IPpmsContextHelper ppmsContextHelper)
        {
            _ppmsContextHelper = ppmsContextHelper;
        }

        public async Task ProcessData()
        {
            await FireActivityAction();            
        }

        private async Task FireActivityAction()
        {
            using (var proxy = await _ppmsContextHelper.GetOrganizationServiceContext())
            {
                proxy.Execute(
                    new OrganizationRequest
                    {
                        RequestName = "ppms_ProviderAgreementExpiration",
                    }
                );
            }
        }
    }
}